"use client";

import { use, useEffect, useState } from "react";
import { notFound } from "next/navigation";
import wordpressAPI from "@/lib/wordpress";
import { useLanguage } from "@/contexts/LanguageContext";

interface PostProps {
  params: Promise<{ slug: string }>; // ✅ params is a Promise now
}

export default function Post({ params }: PostProps) {
  const { slug } = use(params); // ✅ unwrap Promise
  const { language } = useLanguage();
  const [post, setPost] = useState<any | null | undefined>(null);

  useEffect(() => {
    const fetchPost = async () => {
      try {
        const data = await wordpressAPI.getPostBySlug(slug, language);
        setPost(data || undefined);
      } catch (error) {
        console.error("Error loading post:", error);
        setPost(undefined);
      }
    };
    fetchPost();
  }, [slug, language]);

  if (post === null) return null; // loading
  if (post === undefined) notFound(); // not found

  return (
    <div className="te-post prose dark:prose-invert prose-md prose-img:rounded-xl prose-a:text-primary-600 dark:prose-a:text-primary-400 hover:prose-a:text-gray-500 max-w-none">
      <div className="container my-8">
        <h1
          dangerouslySetInnerHTML={{
            __html:
              typeof post.title === "string"
                ? post.title
                : post.title?.rendered || "",
          }}
        />
        <div
          dangerouslySetInnerHTML={{
            __html:
              typeof post.content === "string"
                ? post.content
                : post.content?.rendered || "",
          }}
        />
      </div>
    </div>
  );
}
